/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.ProtoChunkTicks;
import net.minecraft.world.ticks.SerializableTickContainer;
import net.minecraft.world.ticks.TickContainerAccess;

public class ProtoChunk
extends ChunkAccess {
    @Nullable
    private volatile LevelLightEngine f_63151_;
    private volatile ChunkStatus f_63153_ = ChunkStatus.f_62314_;
    private final List<CompoundTag> f_63157_ = Lists.newArrayList();
    private final List<BlockPos> f_63158_ = Lists.newArrayList();
    private final Map<GenerationStep.Carving, CarvingMask> f_63166_ = new Object2ObjectArrayMap();
    @Nullable
    private BelowZeroRetrogen f_188164_;
    private final ProtoChunkTicks<Block> f_63163_;
    private final ProtoChunkTicks<Fluid> f_188165_;

    public ProtoChunk(ChunkPos p_188167_, UpgradeData p_188168_, LevelHeightAccessor p_188169_, Registry<Biome> p_188170_, @Nullable BlendingData p_188171_) {
        this(p_188167_, p_188168_, null, (ProtoChunkTicks<Block>)new ProtoChunkTicks(), (ProtoChunkTicks<Fluid>)new ProtoChunkTicks(), p_188169_, p_188170_, p_188171_);
    }

    public ProtoChunk(ChunkPos p_188173_, UpgradeData p_188174_, @Nullable LevelChunkSection[] p_188175_, ProtoChunkTicks<Block> p_188176_, ProtoChunkTicks<Fluid> p_188177_, LevelHeightAccessor p_188178_, Registry<Biome> p_188179_, @Nullable BlendingData p_188180_) {
        super(p_188173_, p_188174_, p_188178_, p_188179_, 0L, p_188175_, p_188180_);
        this.f_63163_ = p_188176_;
        this.f_188165_ = p_188177_;
    }

    @Override
    public TickContainerAccess<Block> m_183531_() {
        return this.f_63163_;
    }

    @Override
    public TickContainerAccess<Fluid> m_183526_() {
        return this.f_188165_;
    }

    @Override
    public ChunkAccess.TicksToSave m_183568_() {
        return new ChunkAccess.TicksToSave((SerializableTickContainer<Block>)this.f_63163_, (SerializableTickContainer<Fluid>)this.f_188165_);
    }

    @Override
    public BlockState m_8055_(BlockPos p_63264_) {
        int i = p_63264_.m_123342_();
        if (this.m_151562_(i)) {
            return Blocks.f_50626_.m_49966_();
        }
        LevelChunkSection levelchunksection = this.m_183278_(this.m_151564_(i));
        return levelchunksection.m_188008_() ? Blocks.f_50016_.m_49966_() : levelchunksection.m_62982_(p_63264_.m_123341_() & 0xF, i & 0xF, p_63264_.m_123343_() & 0xF);
    }

    @Override
    public FluidState m_6425_(BlockPos p_63239_) {
        int i = p_63239_.m_123342_();
        if (this.m_151562_(i)) {
            return Fluids.f_76191_.m_76145_();
        }
        LevelChunkSection levelchunksection = this.m_183278_(this.m_151564_(i));
        return levelchunksection.m_188008_() ? Fluids.f_76191_.m_76145_() : levelchunksection.m_63007_(p_63239_.m_123341_() & 0xF, i & 0xF, p_63239_.m_123343_() & 0xF);
    }

    @Override
    public Stream<BlockPos> m_6267_() {
        return this.f_63158_.stream();
    }

    public ShortList[] m_63291_() {
        ShortList[] ashortlist = new ShortList[this.m_151559_()];
        for (BlockPos blockpos : this.f_63158_) {
            ChunkAccess.m_62095_(ashortlist, this.m_151564_(blockpos.m_123342_())).add(ProtoChunk.m_63280_(blockpos));
        }
        return ashortlist;
    }

    public void m_63244_(short p_63245_, int p_63246_) {
        this.m_63277_(ProtoChunk.m_63227_(p_63245_, this.m_151568_(p_63246_), this.f_187604_));
    }

    public void m_63277_(BlockPos p_63278_) {
        this.f_63158_.add(p_63278_.m_7949_());
    }

    @Override
    @Nullable
    public BlockState m_6978_(BlockPos p_63217_, BlockState p_63218_, boolean p_63219_) {
        int i = p_63217_.m_123341_();
        int j = p_63217_.m_123342_();
        int k = p_63217_.m_123343_();
        if (j >= this.m_141937_() && j < this.m_151558_()) {
            int l = this.m_151564_(j);
            if (this.f_187612_[l].m_188008_() && p_63218_.m_60713_(Blocks.f_50016_)) {
                return p_63218_;
            }
            if (p_63218_.getLightEmission(this, p_63217_) > 0) {
                this.f_63158_.add(new BlockPos((i & 0xF) + this.m_7697_().m_45604_(), j, (k & 0xF) + this.m_7697_().m_45605_()));
            }
            LevelChunkSection levelchunksection = this.m_183278_(l);
            BlockState blockstate = levelchunksection.m_62986_(i & 0xF, j & 0xF, k & 0xF, p_63218_);
            if (this.f_63153_.m_62427_(ChunkStatus.f_62322_) && p_63218_ != blockstate && (p_63218_.m_60739_(this, p_63217_) != blockstate.m_60739_(this, p_63217_) || p_63218_.getLightEmission(this, p_63217_) != blockstate.getLightEmission(this, p_63217_) || p_63218_.m_60787_() || blockstate.m_60787_())) {
                this.f_63151_.m_142202_(p_63217_);
            }
            EnumSet<Heightmap.Types> enumset = this.m_6415_().m_62500_();
            EnumSet<Heightmap.Types> enumset1 = null;
            for (Heightmap.Types heightmap$types : enumset) {
                Heightmap heightmap = (Heightmap)this.f_187608_.get(heightmap$types);
                if (heightmap != null) continue;
                if (enumset1 == null) {
                    enumset1 = EnumSet.noneOf(Heightmap.Types.class);
                }
                enumset1.add(heightmap$types);
            }
            if (enumset1 != null) {
                Heightmap.m_64256_((ChunkAccess)this, enumset1);
            }
            for (Heightmap.Types heightmap$types1 : enumset) {
                ((Heightmap)this.f_187608_.get(heightmap$types1)).m_64249_(i & 0xF, j, k & 0xF, p_63218_);
            }
            return blockstate;
        }
        return Blocks.f_50626_.m_49966_();
    }

    @Override
    public void m_142169_(BlockEntity p_156488_) {
        this.f_187610_.put(p_156488_.m_58899_(), p_156488_);
    }

    @Override
    @Nullable
    public BlockEntity m_7702_(BlockPos p_63257_) {
        return (BlockEntity)((Object)this.f_187610_.get(p_63257_));
    }

    public Map<BlockPos, BlockEntity> m_63292_() {
        return this.f_187610_;
    }

    public void m_63242_(CompoundTag p_63243_) {
        this.f_63157_.add(p_63243_);
    }

    @Override
    public void m_6286_(Entity p_63183_) {
        if (!p_63183_.m_20159_()) {
            CompoundTag compoundtag = new CompoundTag();
            p_63183_.m_20223_(compoundtag);
            this.m_63242_(compoundtag);
        }
    }

    @Override
    public void m_207296_(ConfiguredStructureFeature<?, ?> p_208116_, StructureStart p_208117_) {
        BelowZeroRetrogen belowzeroretrogen = this.m_183376_();
        if (belowzeroretrogen != null && p_208117_.m_73603_()) {
            BoundingBox boundingbox = p_208117_.m_73601_();
            LevelHeightAccessor levelheightaccessor = this.m_183618_();
            if (boundingbox.m_162396_() < levelheightaccessor.m_141937_() || boundingbox.m_162400_() >= levelheightaccessor.m_151558_()) {
                return;
            }
        }
        super.m_207296_(p_208116_, p_208117_);
    }

    public List<CompoundTag> m_63293_() {
        return this.f_63157_;
    }

    @Override
    public ChunkStatus m_6415_() {
        return this.f_63153_;
    }

    public void m_7150_(ChunkStatus p_63187_) {
        this.f_63153_ = p_63187_;
        if (this.f_188164_ != null && p_63187_.m_62427_(this.f_188164_.m_188466_())) {
            this.m_188183_(null);
        }
        this.m_8092_(true);
    }

    @Override
    public Holder<Biome> m_203495_(int p_204450_, int p_204451_, int p_204452_) {
        if (!(this.m_6415_().m_62427_(ChunkStatus.f_62317_) || this.f_188164_ != null && this.f_188164_.m_188466_().m_62427_(ChunkStatus.f_62317_))) {
            throw new IllegalStateException("Asking for biomes before we have biomes");
        }
        return super.m_203495_(p_204450_, p_204451_, p_204452_);
    }

    public static short m_63280_(BlockPos p_63281_) {
        int i = p_63281_.m_123341_();
        int j = p_63281_.m_123342_();
        int k = p_63281_.m_123343_();
        int l = i & 0xF;
        int i1 = j & 0xF;
        int j1 = k & 0xF;
        return (short)(l | i1 << 4 | j1 << 8);
    }

    public static BlockPos m_63227_(short p_63228_, int p_63229_, ChunkPos p_63230_) {
        int i = SectionPos.m_175554_((int)p_63230_.f_45578_, (int)(p_63228_ & 0xF));
        int j = SectionPos.m_175554_((int)p_63229_, (int)(p_63228_ >>> 4 & 0xF));
        int k = SectionPos.m_175554_((int)p_63230_.f_45579_, (int)(p_63228_ >>> 8 & 0xF));
        return new BlockPos(i, j, k);
    }

    @Override
    public void m_8113_(BlockPos p_63266_) {
        if (!this.m_151570_(p_63266_)) {
            ChunkAccess.m_62095_(this.f_187602_, this.m_151564_(p_63266_.m_123342_())).add(ProtoChunk.m_63280_(p_63266_));
        }
    }

    @Override
    public void m_6561_(short p_63225_, int p_63226_) {
        ChunkAccess.m_62095_(this.f_187602_, p_63226_).add(p_63225_);
    }

    public Map<BlockPos, CompoundTag> m_63294_() {
        return Collections.unmodifiableMap(this.f_187609_);
    }

    @Override
    @Nullable
    public CompoundTag m_8051_(BlockPos p_63275_) {
        BlockEntity blockentity = this.m_7702_(p_63275_);
        return blockentity != null ? blockentity.m_187480_() : (CompoundTag)this.f_187609_.get(p_63275_);
    }

    @Override
    public void m_8114_(BlockPos p_63262_) {
        this.f_187610_.remove(p_63262_);
        this.f_187609_.remove(p_63262_);
    }

    @Nullable
    public CarvingMask m_183612_(GenerationStep.Carving p_188185_) {
        return this.f_63166_.get(p_188185_);
    }

    public CarvingMask m_183613_(GenerationStep.Carving p_188191_) {
        return this.f_63166_.computeIfAbsent(p_188191_, p_188193_ -> new CarvingMask(this.m_141928_(), this.m_141937_()));
    }

    public void m_188186_(GenerationStep.Carving p_188187_, CarvingMask p_188188_) {
        this.f_63166_.put(p_188187_, p_188188_);
    }

    public void m_63209_(LevelLightEngine p_63210_) {
        this.f_63151_ = p_63210_;
    }

    public void m_188183_(@Nullable BelowZeroRetrogen p_188184_) {
        this.f_188164_ = p_188184_;
    }

    @Override
    @Nullable
    public BelowZeroRetrogen m_183376_() {
        return this.f_188164_;
    }

    private static <T> LevelChunkTicks<T> m_188189_(ProtoChunkTicks<T> p_188190_) {
        return new LevelChunkTicks(p_188190_.m_193306_());
    }

    public LevelChunkTicks<Block> m_188181_() {
        return ProtoChunk.m_188189_(this.f_63163_);
    }

    public LevelChunkTicks<Fluid> m_188182_() {
        return ProtoChunk.m_188189_(this.f_188165_);
    }

    @Override
    public LevelHeightAccessor m_183618_() {
        return this.m_187679_() ? BelowZeroRetrogen.f_188456_ : this;
    }
}

